/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Custom Bitmap for splashscreen
 *
 * You may use one of the following tools to generate the C++ bitmap array from
 * a black and white image:
 *
 *  - http://www.marlinfw.org/tools/u8glib/converter.html
 *  - http://www.digole.com/tools/PicturetoC_Hex_converter.php
 */
#include <avr/pgmspace.h>

#define CUSTOM_BOOTSCREEN1_TIMEOUT   1000
#define CUSTOM_BOOTSCREEN1_BMPWIDTH  128
#define CUSTOM_BOOTSCREEN1_BMPHEIGHT 64

const unsigned char custom_start_bmp1[1024] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0xfe, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0xee, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x03, 0xce, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x03, 0x8e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x07, 0x0e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0e, 0x0e, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x9e, 0x0e, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfc, 0x0e, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x0e, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0e, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x0e, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xce, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfe, 0x3f, 0xfc, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x3c, 0x7f, 0xfe, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x06, 0x00, 0x78, 0xff, 0xff, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0xf0, 0x00, 0x00, 0x00, 0x07, 0x00, 0xf1, 0xfe, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x78, 0x00, 0x00, 0x00, 0x07, 0x01, 0xe3, 0xfc, 0x0f, 0xc0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x3c, 0x00, 0x00, 0x00, 0x03, 0x83, 0xc7, 0xf9, 0xef, 0xe0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x1f, 0x00, 0x00, 0x00, 0x03, 0x87, 0x8f, 0xf8, 0xff, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x07, 0x80, 0x00, 0x00, 0x01, 0xdf, 0x1f, 0xfc, 0x7f, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x03, 0xc0, 0x00, 0x00, 0x01, 0xfe, 0x3f, 0xfe, 0x3f, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x01, 0xe0, 0x00, 0x00, 0x01, 0xfc, 0x7f, 0xfc, 0x0f, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf9, 0xcf, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf3, 0xe7, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x01, 0xf8, 0x00, 0x00, 0x01, 0xfc, 0x7f, 0xf3, 0xe7, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x03, 0xf8, 0x00, 0x00, 0x01, 0xfe, 0x3f, 0xf3, 0xe7, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x07, 0xb8, 0x00, 0x00, 0x01, 0xdf, 0x1f, 0xf3, 0xe7, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x1f, 0x1c, 0x00, 0x00, 0x03, 0x87, 0x8f, 0xf3, 0xe7, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x3c, 0x1c, 0x00, 0x00, 0x03, 0x83, 0xc7, 0xf1, 0xc7, 0xe0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0x78, 0x0e, 0x00, 0x00, 0x07, 0x01, 0xe3, 0xf8, 0x0f, 0xc0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0e, 0xf0, 0x0e, 0x00, 0x00, 0x07, 0x00, 0xf1, 0xfe, 0x3f, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xe0, 0x07, 0x00, 0x00, 0x0e, 0x00, 0x78, 0xff, 0xff, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xc0, 0x07, 0x00, 0x00, 0x0e, 0x00, 0x3c, 0x7f, 0xfe, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xfe, 0x3f, 0xfc, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf0, 0x00, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfc, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x07, 0x80, 0x07, 0x3f, 0x9f, 0xce, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0x0f, 0xff, 0x0e, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xe0, 0x07, 0x01, 0xf8, 0x0e, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x01, 0xf8, 0x0e, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x78, 0x07, 0x03, 0xfc, 0x0e, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3c, 0x07, 0x03, 0x9e, 0x0e, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1e, 0x07, 0x07, 0x0e, 0x0e, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0f, 0x07, 0x0e, 0x07, 0x0e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x87, 0x1c, 0x03, 0x8e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xc7, 0x3c, 0x03, 0xce, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xe7, 0x78, 0x01, 0xee, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0x70, 0x00, 0xfe, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

#define CUSTOM_BOOTSCREEN2_TIMEOUT   1000
#define CUSTOM_BOOTSCREEN2_BMPWIDTH  128
#define CUSTOM_BOOTSCREEN2_BMPHEIGHT 64

const unsigned char custom_start_bmp2[1024] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0c, 0x18, 0xfe, 0x3f, 0x87, 0xf8, 0xfe, 0x31, 0x80, 0x0d, 0xe1, 0xfc, 0x60, 0x7f, 0x86, 0x00, 
0x0c, 0x18, 0xfe, 0x3f, 0xc7, 0xf8, 0xfe, 0x31, 0x80, 0x0d, 0xf1, 0xfc, 0x60, 0x7f, 0x86, 0x00, 
0x0c, 0x18, 0xc0, 0x30, 0xc0, 0x00, 0xc0, 0x31, 0x80, 0x0c, 0x31, 0x80, 0x60, 0x00, 0x06, 0x00, 
0x06, 0x30, 0xc0, 0x30, 0xc0, 0xc0, 0xc0, 0x1b, 0x80, 0x0c, 0x31, 0x80, 0x60, 0x0c, 0x0c, 0x00, 
0x06, 0x30, 0x00, 0x30, 0xc0, 0xc0, 0x00, 0x1b, 0x00, 0x0c, 0x30, 0x00, 0x60, 0x0c, 0x0d, 0x80, 
0x06, 0x30, 0xf8, 0x00, 0xc0, 0xc0, 0xf8, 0x08, 0x00, 0x0c, 0x31, 0xf0, 0x60, 0x0c, 0x0d, 0x80, 
0x03, 0x60, 0xf8, 0x3f, 0xc0, 0xc0, 0xf8, 0x0c, 0x00, 0x0c, 0x31, 0xf0, 0x60, 0x0c, 0x0d, 0x80, 
0x03, 0x60, 0xc0, 0x3f, 0x80, 0xc0, 0xc0, 0x0c, 0x00, 0x0c, 0x31, 0x80, 0x60, 0x0c, 0x18, 0xc0, 
0x03, 0x60, 0xc0, 0x33, 0x00, 0xc0, 0xc0, 0x1b, 0x00, 0x0c, 0x31, 0x80, 0x60, 0x0c, 0x1b, 0xc0, 
0x03, 0x00, 0xc0, 0x31, 0x80, 0xc0, 0xc0, 0x1b, 0x00, 0x0c, 0x31, 0x80, 0x60, 0x0c, 0x1b, 0xc0, 
0x01, 0x80, 0xc0, 0x31, 0xc0, 0xc0, 0xc0, 0x31, 0x80, 0x0c, 0x31, 0x80, 0x60, 0x0c, 0x30, 0x60, 
0x01, 0x80, 0xfe, 0x30, 0xc0, 0xc0, 0xfe, 0x31, 0x80, 0x0f, 0xf1, 0xfc, 0x6f, 0x0c, 0x30, 0x60, 
0x01, 0x80, 0xfe, 0x30, 0xc0, 0xc0, 0xfe, 0x31, 0x80, 0x0f, 0xe1, 0xfc, 0x6f, 0x0c, 0x30, 0x60, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

#define CUSTOM_BOOTSCREEN3_TIMEOUT   1000
#define CUSTOM_BOOTSCREEN3_BMPWIDTH  128
#define CUSTOM_BOOTSCREEN3_BMPHEIGHT 64

const unsigned char custom_start_bmp3[1024] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 
0x1f, 0x03, 0xc0, 0x3e, 0x07, 0xcf, 0x80, 0x7c, 0x0f, 0x7c, 0x7c, 0x01, 0xfb, 0xcf, 0x7c, 0x54, 
0x1f, 0x83, 0xc0, 0xff, 0x87, 0xcf, 0x81, 0xff, 0x0f, 0xfe, 0xfe, 0x07, 0xff, 0xcf, 0xfe, 0x44, 
0x0f, 0x83, 0xc1, 0xff, 0xc7, 0xcf, 0x83, 0xff, 0x8f, 0xff, 0xff, 0x0f, 0xff, 0xcf, 0xff, 0x38, 
0x07, 0xc3, 0xc3, 0xff, 0xe7, 0xcf, 0x87, 0xff, 0xcf, 0xff, 0xff, 0x1f, 0xff, 0xcf, 0xff, 0x00, 
0x07, 0xe3, 0xc7, 0xff, 0xe7, 0xcf, 0x8f, 0xff, 0xcf, 0xff, 0xff, 0x3f, 0x1f, 0xcf, 0x9f, 0x00, 
0x03, 0xe3, 0xc7, 0xc7, 0xe7, 0xcf, 0x8f, 0x8f, 0xcf, 0x8f, 0x8f, 0x3e, 0x0f, 0xcf, 0x0f, 0x00, 
0x01, 0xf3, 0xcf, 0x8f, 0xc7, 0xcf, 0x9f, 0x1f, 0x8f, 0x0f, 0x0f, 0x3c, 0x07, 0xcf, 0x0f, 0x00, 
0x01, 0xf3, 0xcf, 0x9f, 0x87, 0xcf, 0x9f, 0x3f, 0x0f, 0x0f, 0x0f, 0x3c, 0x07, 0xcf, 0x0f, 0x00, 
0x00, 0xfb, 0xcf, 0x7e, 0x07, 0xcf, 0x9e, 0xfc, 0x0f, 0x0f, 0x0f, 0x3c, 0x07, 0xcf, 0x0f, 0x00, 
0x00, 0xff, 0xcf, 0xfc, 0x27, 0xcf, 0x9f, 0xf8, 0x4f, 0x0f, 0x0f, 0x3c, 0x07, 0xcf, 0x0f, 0x00, 
0x00, 0x7f, 0xcf, 0xf8, 0x67, 0xcf, 0x9f, 0xf0, 0xcf, 0x0f, 0x0f, 0x3c, 0x07, 0xcf, 0x0f, 0x00, 
0x00, 0x7f, 0xc7, 0xe1, 0xe7, 0xcf, 0x8f, 0xc3, 0xcf, 0x0f, 0x0f, 0x3e, 0x0f, 0xcf, 0x0f, 0x00, 
0x00, 0x3f, 0xc7, 0xff, 0xe7, 0xcf, 0x8f, 0xff, 0xcf, 0x0f, 0x0f, 0x3f, 0x1f, 0xcf, 0x0f, 0x00, 
0x00, 0x1f, 0xc7, 0xff, 0xe7, 0xcf, 0x8f, 0xff, 0xcf, 0x0f, 0x0f, 0x1f, 0xff, 0xcf, 0x0f, 0x00, 
0x00, 0x1f, 0xc3, 0xff, 0xc7, 0xcf, 0x87, 0xff, 0x8f, 0x0f, 0x0f, 0x0f, 0xff, 0xcf, 0x0f, 0x00, 
0x00, 0x0f, 0xc1, 0xff, 0x87, 0xcf, 0x83, 0xff, 0x0f, 0x0f, 0x0f, 0x07, 0xff, 0xcf, 0x0f, 0x00, 
0x00, 0x07, 0xc0, 0x7e, 0x07, 0xcf, 0x80, 0xfc, 0x0f, 0x0f, 0x0f, 0x03, 0xfb, 0xcf, 0x0f, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xbf, 0xdf, 0xf3, 0x7f, 0xbf, 0xdf, 0x0f, 0xff, 0xff, 0xff, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xbf, 0xdf, 0xf3, 0x7f, 0xbf, 0xdf, 0x0f, 0xff, 0xff, 0xff, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x61, 0xb0, 0x18, 0x33, 0x61, 0xb0, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x61, 0xb0, 0x18, 0x33, 0x7f, 0xb0, 0x18, 0x0f, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x61, 0xb0, 0x18, 0x33, 0x7f, 0xb0, 0x18, 0x07, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x61, 0xb0, 0x18, 0x33, 0x60, 0x30, 0x18, 0x00, 0x30, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xb0, 0x1f, 0xf3, 0x7f, 0xbf, 0xdf, 0xef, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xb0, 0x1f, 0xf3, 0x7f, 0xbf, 0xdf, 0xef, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

#define CUSTOM_BOOTSCREEN4_TIMEOUT   500
#define CUSTOM_BOOTSCREEN4_BMPWIDTH  128
#define CUSTOM_BOOTSCREEN4_BMPHEIGHT 64

const unsigned char custom_start_bmp4[1024] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xe0, 0x00, 0xff, 0xe0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xf0, 0x01, 0xff, 0xf0, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xf8, 0x01, 0xff, 0xf0, 0x03, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xfe, 0x0f, 0xff, 0xfe, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0f, 0xff, 0x3f, 0xff, 0xff, 0x9f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xf8, 0x00, 0x0c, 0xe3, 0x28, 0x73, 0x25, 0x4c, 0x60, 
0x00, 0x03, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x12, 0x94, 0xb4, 0x84, 0xa5, 0x92, 0x90, 
0x00, 0x07, 0xff, 0xfe, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x12, 0x97, 0xa4, 0x64, 0xa5, 0x10, 0xf0, 
0x00, 0x3f, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xff, 0x80, 0x12, 0x94, 0x24, 0x14, 0xa5, 0x10, 0x80, 
0x0f, 0xff, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x12, 0xe4, 0xa4, 0x94, 0xa5, 0x12, 0x90, 
0x0f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x0c, 0x83, 0x24, 0x63, 0x19, 0x0c, 0x60, 
0x0f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0f, 0xff, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0f, 0xff, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 
0x0f, 0xff, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 
0x0f, 0xff, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0xe3, 0x29, 0xd0, 0x26, 0x53, 0x00, 
0x0f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x90, 0xb2, 0x4a, 0x41, 0x64, 0x80, 
0x0f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x93, 0xa2, 0x4b, 0x47, 0x47, 0x80, 
0x0f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x94, 0xa2, 0x4d, 0xc9, 0x44, 0x00, 
0x00, 0x3f, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xff, 0x80, 0x00, 0x94, 0xa2, 0x44, 0x89, 0x44, 0x80, 
0x00, 0x07, 0xff, 0xfe, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x93, 0xa1, 0xc4, 0x87, 0x43, 0x00, 
0x00, 0x03, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xfe, 0x00, 0x0f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xfe, 0x00, 0x0f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0f, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0f, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xfe, 0x30, 0x00, 0x01, 0x8f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
